// id 4074 (no localStorage version)
window.addEventListener('DOMContentLoaded', () => {

    const html = document.querySelector('html'),
        currLangDom = document.querySelector('.curr_lang'),
        langSwitcherOuter = document.querySelector('.lang_switcher_outer'),
        langSwitcherWrapper = document.querySelector('.switcher__wrapper'),
        langListItem = [...document.querySelectorAll('.lang_list_item')],
        userLangBrowser = navigator.language || navigator.userLanguage,
        languageParts = userLangBrowser.split('-'),
        userLang = languageParts[0],
        country = html.getAttribute('data-country');

    // === 移除语言切换 UI（按你的要求不显示） ===
    if (langSwitcherWrapper) {
        langSwitcherWrapper.remove();
    }

    const listOfLang = ['en', 'pl', 'de', 'ru', 'fi', 'pt', 'es', 'hu', 'fr', 'ro', 'it', 'bg', 'se', 'ph', 'vn', 'th', 'jp', 'dk', 'no', 'gr', 'lt', 'lv', 'ee', 'sk'];

    const countryToLang = {
        en: 'en',
        pl: 'pl',
        de: 'de',
        ru: 'ru',
        fi: 'fi',
        pt: 'pt',
        es: 'es',
        hu: 'hu',
        fr: 'fr',
        ro: 'ro',
        it: 'it',
        bg: 'bg',
        sv: 'se',
        fil: 'ph',
        vi: 'vn',
        th: 'th',
        ja: 'jp',
        da: 'dk',
        nb: 'no',
        nn: 'no',
        no: 'no',
        el: 'gr',
        lt: 'lt',
        lv: 'lv',
        et: 'ee',
        sk: 'sk',
        default: 'en'
    };

    const data = {
        "by": {"countWB": "1200 USD"},
        "az": {"countWB": "1200 USD"},
        "am": {"countWB": "1200 USD"},
        "ge": {"countWB": "1200 USD"},
        "md": {"countWB": "1200 USD"},
        "mn": {"countWB": "1200 USD"},
        "tm": {"countWB": "1200 USD"},
        "kg": {"countWB": "1200 USD"},
        "tj": {"countWB": "1200 USD"},
        "nz": {"countWB": "1200 NZD"},
        "ck": {"countWB": "1200 NZD"},
        "nu": {"countWB": "1200 NZD"},
        "pn": {"countWB": "1200 NZD"},
        "tk": {"countWB": "1200 NZD"},
        "dk": {"countWB": "6000 DKK"},
        "fo": {"countWB": "6000 DKK"},
        "gl": {"countWB": "6000 DKK"},
        "in": {"countWB": "60000 INR"},
        "bt": {"countWB": "60000 INR"},
        "np": {"countWB": "60000 INR"},
        "ch": {"countWB": "1200 CHF"},
        "li": {"countWB": "1200 CHF"},
        "ca": {"countWB": "1200 CAD"},
        "pm": {"countWB": "1200 CAD"},
        "no": {"countWB": "12000 NOK"},
        "sj": {"countWB": "12000 NOK"},
        "cl": {"countWB": "850000 CLP"},
        "pl": {"countWB": "5000 PLN"},
        "mx": {"countWB": "30000 MXN"},
        "co": {"countWB": "5000000 COP"},
        "ar": {"countWB": "600000 ARS"},
        "br": {"countWB": "6000 BRL"},
        "hu": {"countWB": "360000 HUF"},
        "jp": {"countWB": "120000 JPY"},
        "pe": {"countWB": "5000 PEN "},
        "ph": {"countWB": "60000 PHP"},
        "ro": {"countWB": "4800 RON"},
        "th": {"countWB": "36000 THB"},
        "vn": {"countWB": "30000000 VND"},
        "bg": {"countWB": "2400 BGN"},
        "se": {"countWB": "12000 SEK"},
        "default": {"countWB": "1200 EUR"}
    };

    /** automatically add values from max (wheel sectors, etc) **/
    const inputValue = data[country] ? data[country].countWB : data.default.countWB;
    const result = processValue(inputValue);

    function processValue(inputValue) {
        const [numbers, currencyIndex] = inputValue.match(/\d+(\s+\d+)*|\D+/g);
        if (numbers && currencyIndex) {
            const numericValue = numbers.replace(/ /g, '');
            return {
                fullBonus: numericValue + ' ' + currencyIndex,
                bonusHalf: Math.round(numericValue / 2) + currencyIndex,
                isoBonus: currencyIndex,
                currencyIndex
            };
        }
        return [];
    }

    function changeBonusContent(bonusWrapper, bonus) {
        let formattedNumber;
        bonusWrapper.forEach(item => {
            const numericPart = result[bonus].match(/\d+/)[0];
            const currencyPart = result[bonus].replace(numericPart, '');

            if (numericPart.length > 4) {
                formattedNumber = numericPart.replace(/\B(?=(\d{3})+(?!\d))/g, " ") + currencyPart;
            } else {
                formattedNumber = numericPart + currencyPart;
            }

            item.textContent = formattedNumber;
            item.setAttribute('data-text', formattedNumber);
        });
    }

    const fullBonus = [...document.querySelectorAll('.bonus-full')];
    const halfBonus = [...document.querySelectorAll('.bonus-half')];
    const isoBonus = [...document.querySelectorAll('.bonus-iso')];

    changeBonusContent(fullBonus, 'fullBonus');
    changeBonusContent(halfBonus, 'bonusHalf');
    changeBonusContent(isoBonus, 'isoBonus');
    /** END of automatically add values from max (wheel sectors, etc) **/

    // add class curr_lang
    if (country) {
        Object.keys(data).forEach(item => {
            if (item === country) {
                html.classList.add(`curr_${country}`);
            }
        });
    }

    const dataCurrency = [
        "en", "by", "am", "ge", "md", "mn", "tm", "kg", "tj", "nz", "ck", "nu", "pn", "tk",
        "dk", "fo", "gl", "in", "bt", "np", "ca", "pm", "no", "sj", "cl", "pl", "mx",
        "co", "ar", "br", "cz", "hu", "jp", "kz", "pe", "ph", "th", "vn", "az"
    ];

    for (let i = 0; i < dataCurrency.length; i++) {
        if (country === dataCurrency[i]) {
            html.classList.add('curr_' + dataCurrency[i]);
        }
    }

    // 自动选择语言（仍保留页面文案切换逻辑，但 UI 已移除）
    let lang = countryToLang[userLang] || countryToLang.default;
    listOfLang.forEach(item => {
        html.classList.remove(item);
        html.classList.add(lang);
        html.setAttribute('data-lang', lang);
    });

    // 如果 UI 存在（理论上已删除），也不再绑定事件
    const changeLanguage = item => {
        hidePreloader();
        const lang = item.getAttribute('data-lang');
        listOfLang.forEach(k => {
            html.classList.contains(k) && html.classList.remove(k);
        });
        html.classList.add(lang);
        html.setAttribute('data-lang', lang);
        if (langListItem.length) {
            langListItem.forEach(li => li.classList.remove('curr'));
            item.classList.add('curr');
        }
        if (currLangDom) currLangDom.innerHTML = item.innerHTML;
    };

    if (langListItem.length && currLangDom && langSwitcherOuter) {
        langListItem.forEach(item => {
            item.classList.remove('curr');
            item.addEventListener('click', () => changeLanguage(item));
        });

        const currLangItem = langListItem.find(
            item => item.getAttribute('data-lang') === lang
        );

        if (currLangItem) {
            currLangItem.classList.add('curr');
            currLangDom.innerHTML = currLangItem.innerHTML;
        } else if (currLangDom) {
            currLangDom.innerHTML = `<span>${countryToLang.default}</span>`;
        }

        langSwitcherOuter.addEventListener('click', () => {
            langSwitcherOuter.classList.toggle('act');
        });

        document.addEventListener('click', e => {
            !e.target.closest('.lang_switcher_outer') &&
            langSwitcherOuter.classList.remove('act');
        });
    }

    document.querySelector('#year').innerText = (new Date().getFullYear());

    const hidePreloader = () => {
        html.classList.remove('hide');
        setTimeout(function () {
            html.classList.add('hide');
        }, 1000);
    };

    hidePreloader();

    const textEffect = document.querySelectorAll('.text-effect span');
    for (let i = 0; i < textEffect.length; i++) {
        const content = textEffect[i].textContent;
        const parent = textEffect[i].parentElement;
        parent.setAttribute('data-before', content);
    }

    const wheel = document.querySelector('.wheel'),
        wheelSpinner = document.querySelector('.wheel-spinner'),
        wheelButton = document.querySelector('.wheel-btn'),
        gameWheel = document.querySelector('.game-wheel'),
        gameCards = document.querySelector('.game-cards'),
        popup = document.querySelector('.popup'),
        popupBtn = document.querySelector('.popup-btn'),
        popupWindow1 = document.querySelector('.popup-window-1'),
        popupWindow2 = document.querySelector('.popup-window-2'),
        charactersWheel = document.querySelector('.characters-wheel'),
        charactersCards = document.querySelector('.characters-cards');

    // ======= 转盘交互（去除 localStorage）=======
    wheelButton.addEventListener('click', () => {
        wheel.classList.add('wheel-active');
        wheelButton.disabled = true;
        wheelSpinner.classList.add('wheel-spinner_animated_1');
        wheelSpinner.classList.remove('wheel-spinner_animated');
        setTimeout(function () {
            popup.classList.add('popup-show');
            popupWindow1.classList.add('popup-window-show');
            // no persistence
        }, 4000);
    });


  
    
    // 粒子效果
    particlesJS("particles-js", {
        "particles": {
            "number": {"value": 150, "density": {"enable": true, "value_area": 3000}},
            "color": {"value": "#86FA0E"},
            "shape": {
                "type": "image",
                "image": {
                    "src": "data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='40' height='20'><ellipse cx='20' cy='10' rx='20' ry='10' fill='%2386FA0E'/></svg>",
                    "width": 40,
                    "height": 20
                }
            },
            "opacity": {"value": 0.9, "random": true, "anim": {"enable": false, "speed": 1, "opacity_min": 0.1, "sync": false}},
            "size": {"value": 4, "random": true, "anim": {"enable": true, "speed": 3, "size_min": 0, "sync": false}},
            "line_linked": {"enable": false, "distance": 700, "color": "#FFF", "opacity": 0.4, "width": 2},
            "move": {"enable": true, "speed": 2, "direction": "top", "random": true, "straight": false, "out_mode": "out", "bounce": false, "attract": {"enable": false, "rotateX": 600, "rotateY": 1200}}
        },
        "interactivity": {
            "detect_on": "window",
            "events": {"onhover": {"enable": false, "mode": "repulse"}, "onclick": {"enable": false, "mode": "repulse"}, "resize": true},
            "modes": {
                "grab": {"distance": 1400, "line_linked": {"opacity": 0.1}},
                "bubble": {"distance": 400, "size": 6, "duration": 0.3, "opacity": 1, "speed": 3},
                "repulse": {"distance": 200, "duration": 0.4},
                "push": {"particles_nb": 4},
                "remove": {"particles_nb": 2}
            }
        },
        "retina_detect": true
    });

    // ======= 去掉基于 localStorage 的还原逻辑（不再持久化状态）=======
    // 之前会根据 localStorage.status_4074 还原 UI，这里完全移除。
});
